<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Exports\SuperAdmin\EventsExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\SuperAdmin\Events\CreateRequest;
use App\Http\Requests\ImportRequest;
use App\Imports\SuperAdmin\EventsImport;
use App\Models\Event;
use App\Models\EventCategory;
use App\Models\TherapistCommunity;
use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class TherapistCommunityEventsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('permission:therapist_community.add_event');
        $this->middleware('permission:therapist_community.add_event', ['only' => ['store']]);
        $this->middleware('permission:therapist_community.add_event', ['only' => ['update']]);
        $this->middleware('permission:therapist_community.add_event', ['only' => ['destroy']]);
        $this->middleware('permission:therapist_community.add_event', ['only' => ['export']]);
        $this->middleware('permission:therapist_community.add_event', ['only' => ['import']]);
    }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null, $therapist_community)
    {
        if ($req != null) {
            $therapist_community_events =  $therapist_community->therapist_community_events();
            if ($req->trash && $req->trash == 'with') {
                $therapist_community_events =  $therapist_community_events->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_community_events =  $therapist_community_events->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_community_events = $therapist_community_events->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_community_events = $therapist_community_events->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_community_events = $therapist_community_events->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_community_events = $therapist_community_events->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_community_events = $therapist_community_events->get();
                return $therapist_community_events;
            }
            $therapist_community_events = $therapist_community_events->get();
            return $therapist_community_events;
        }
        $therapist_community_events = $therapist_community->therapist_community_events()->withAll()->orderBy('id', 'desc')->get();
        return $therapist_community_events;
    }


    /*********View All Events  ***********/
    public function index(Request $request, TherapistCommunity $therapist_community)
    {
        $therapist_community_events = $this->getter($request, null, $therapist_community);
        return view('super_admins.therapist_communitys.therapist_community_events.index', compact('therapist_community_events', 'therapist_community'));
    }

    /*********View Create Form of Event  ***********/
    public function create(TherapistCommunity $therapist_community)
    {
        $tags = Tag::active()->get();
        $event_categories = EventCategory::active()->get();
        return view('super_admins.therapist_communitys.therapist_community_events.create', compact('therapist_community', 'tags', 'event_categories'));
    }

    /*********Store Event  ***********/
    public function store(CreateRequest $request, TherapistCommunity $therapist_community)
    {
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            $request->merge(['created_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_events');
            $therapist_community_event = $therapist_community->therapist_community_events()->create($data);
            $therapist_community_event->slug = Str::slug($therapist_community_event->name . ' ' . $therapist_community_event->id, '-');
            $therapist_community_event->save();
            foreach ($request->sponsers as $sponser) {
                $image_url = uploadArrayFile($sponser, 'image', 'event_sponsers');
                $therapist_community_event->sponsers()->create([
                    'name' => $sponser['name'],
                    'image' => $image_url
                ]);
            }
            $therapist_community_event->tags()->sync($request->tag_ids);
            $therapist_community_event = $therapist_community->therapist_community_events()->withAll()->find($therapist_community_event->id);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_events.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_events.index', $therapist_community->id)->with('message', 'Event Created Successfully')->with('message_type', 'success');
    }

    /*********View Event  ***********/
    public function show(TherapistCommunity $therapist_community, Event $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        return view('super_admins.therapist_communitys.therapist_community_events.show', compact('therapist_community_event', 'therapist_community'));
    }

    /*********View Edit Form of Event  ***********/
    public function edit(TherapistCommunity $therapist_community, Event $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        $tags = Tag::active()->get();
        $event_categories = EventCategory::active()->get();
        return view('super_admins.therapist_communitys.therapist_community_events.edit', compact('therapist_community_event', 'therapist_community', 'tags', 'event_categories'));
    }

    /*********Update Event  ***********/
    public function update(CreateRequest $request, TherapistCommunity $therapist_community, Event $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            $request->merge(['last_updated_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_community_events', $therapist_community_event->image);
            } else {
                $data['image'] = $therapist_community_event->image;
            }
            $therapist_community_event->sponsers()->delete();
            foreach ($request->sponsers as $sponser) {
                if (isset($sponser['image'])) {
                    if (is_string($sponser['image']) && $sponser['image'] != 'undefined') {
                        $image_url = $sponser['previous_image'];
                    } else {
                        $image_url = uploadArrayFile($sponser, 'image', 'event_sponsers');
                    }
                }
                $therapist_community_event->sponsers()->create([
                    'name' => $sponser['name'],
                    'image' => $image_url
                ]);
            }
            $therapist_community_event->update($data);
            $therapist_community_event = Event::find($therapist_community_event->id);
            $slug = Str::slug($therapist_community_event->name . ' ' . $therapist_community_event->id, '-');
            $therapist_community_event->update([
                'slug' => $slug
            ]);
            $therapist_community_event->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_events.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_events.index', $therapist_community->id)->with('message', 'Event Updated Successfully')->with('message_type', 'success');
    }

    /********* Export  CSV And Excel  **********/
    public function export(Request $request)
    {
        $therapist_community_events = $this->getter($request, "export");
        if (in_array($request->export, ['csv,xlsx'])) {
            $extension = $request->export;
        } else {
            $extension = 'xlsx';
        }
        $filename = "therapist_community_events." . $extension;
        return Excel::download(new EventsExport($therapist_community_events), $filename);
    }
    /********* Import CSV And Excel  **********/
    public function import(ImportRequest $request)
    {
        $file = $request->file('file');
        Excel::import(new EventsImport, $file);
        return redirect()->back()->with('message', 'Event Categories imported Successfully')->with('message_type', 'success');
    }


    /*********Soft DELETE Event ***********/
    public function destroy(TherapistCommunity $therapist_community, Event $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        $therapist_community_event->delete();
        return redirect()->back()->with('message', 'Event Deleted Successfully')->with('message_type', 'success');
    }

    /*********Permanently DELETE Event ***********/
    public function destroyPermanently(Request $request, TherapistCommunity $therapist_community, $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        $therapist_community_event = Event::withTrashed()->find($therapist_community_event);
        if ($therapist_community_event) {
            if ($therapist_community_event->trashed()) {
                if ($therapist_community_event->image && file_exists(public_path($therapist_community_event->image))) {
                    unlink(public_path($therapist_community_event->image));
                }
                $therapist_community_event->forceDelete();
                return redirect()->back()->with('message', 'Event Deleted Successfully')->with('message_type', 'success');
            } else {
                return redirect()->back()->with('message', 'Event is Not in Trash')->with('message_type', 'error');
            }
        } else {
            return redirect()->back()->with('message', 'Event Not Found')->with('message_type', 'error');
        }
    }
    /********* Restore Event***********/
    public function restore(Request $request, TherapistCommunity $therapist_community, $therapist_community_event)
    {
        if ($therapist_community->id != $therapist_community_event->therapist_community_id) {
            return redirect()->back()->with('message', 'TherapistEducation Not Found')->with('message_type', 'error');
        }
        $therapist_community_event = Event::withTrashed()->find($therapist_community_event);
        if ($therapist_community_event->trashed()) {
            $therapist_community_event->restore();
            return redirect()->back()->with('message', 'Event Restored Successfully')->with('message_type', 'success');
        } else {
            return redirect()->back()->with('message', 'Event Not Found')->with('message_type', 'error');
        }
    }
}
